# SmartUI::Tab Class
This is a basic usage of SmartUI's ```Tab``` class. If you want to know more about the real HTML layout, click [here](general-elements.php)
```php
SmartUI::Tab($tabs [, $options = array()])
```

## $tabs
The ```$tabs``` parameter will initiate the number of tabs displayed. You can pass either an ```assoc``` array that contains tab ids or just an ```array```(not recomended) hense ids will be the zero base index number.
```php
$tabs = array(
	'my-tab-1' => array(
		'content' => '',
		'title' => 'Tab 1',
		'icon' => '',
		'dropdown' => '',
		'position' => '',
		'active' => false,
		'fade' => false
	),
	'my-tab-2' => array(
		'content' => '',
		'title' => 'Tab 2',
		'icon' => '',
		'dropdown' => '',
		'position' => '',
		'active' => false,
		'fade' => false
	)
	// so on ...
)

// or ...
$tabs = array(
	'my-tab-1' => 'Tab 1', // value acts as the 'title' property
	'my-tab-2' => 'Tab 2',
	// so on ...
);

// or ...
$tabs = array('Tab 1', 'Tab 2'); // tab #0 and #1 as ids
```

## Setup
```php


$mytabs = array(
	'my-tab-1' => 'Tab 1',
	'my-tab-2' => 'Tab 2'
);

$tab = $_ui->create_tab($mytabs);
```

## Usage
```php
$tab->content('my-tab-1', 'This is the content of my tab 1');
$tab->content('my-tab-2', 'This is the content of my tab 2');
```

## Print it!
```php
$tab->print_html();
```

## Property Reference
Below are the list of available properties for the class:

### Tab::tab
An ```array```. The list of tabs (provided upon creation of ```SmartUI::Tab```)
```php
$tab->tab('my-tab-1', array('content' => 'The content of this tab'));

// or ...
$tab->tab('my-tab-1', 'My Tab 1'); // set as tab's 'title' property
```

### Tab::content
An ```array``` or ```closure``` of tabs with their ```content``` property.
```php
$tab->content = array(
	'my-tab-1' => 'This is the content of my tab 1'
);

// or ...
$tab->content('my-tab-1', 'This is the content of my tab 1');

// or even closure with callback (optional)
$tab->content('my-tab-1', function($this, $tabs) {
	return 'This is the content of my tab and I am coding some stuff here to return';
}, function($this) {
	// your callback code here ...
})
```
Below other properties that are using the same setup as ```Tab::content``` property
### Tab::icon
### Tab::title
### Tab::dropdown
This one uses ```SmartUI::print_dropdown``` function. You can either pass an ```array``` of the dropdown's format or pure ```HTML``` string. Passing a ```closure``` needs you to return either ```array``` or ```HTML string```
```php
$dropdown_items = array(
	'<a href="javascript:void(0);">Some action</a>',
	'<a href="javascript:void(0);">Some other action</a>',
	'-',
	'<a href="javascript:void(0);">Some action below separator</a>'
);
$tab->dropdown('my-tab-2', $dropdown_items);
```
### Tab::position

### Tab::content_id
A ```string``` - id attribute of ```<div class="tab-content ... " ... > ... </div>```

### Tab::tabs_id
A ```string``` - id attribute of ```<ul class="tabs ... " ... > ... </div>```

### Tab::options
An ```array``` - options available for the class
```php
$options = array(
	'bordered' => true,
	'position' => '',
	'pull' => '',
	'padding' => 10,
	'widget' => false
);

// sample call
$tab->options('bordered', true);

```